package jadean.dean.java.resources;

import jadean.dean.java.JavaProject;
import jadean.dean.java.resourceparser.javaparser.visitors.GetResourceContextVisitor;
import jadean.dean.java.utilities.FileUtilities;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;


public class JavaResourceContextFactory {
	
	public static JavaResourceContext getResourceContext(JavaProject p, String className) {
		CompilationUnit cu;
		try {
			cu = JavaParser.parse(new FileInputStream(FileUtilities.findInDirs(p.getSourceFolders(), className.replace('.', File.separatorChar) + ".java")));
			GetResourceContextVisitor<String> gcncv = new GetResourceContextVisitor<String>();
			cu.accept(gcncv, null);
			return gcncv.getClassNameContext();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (ParseException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	return new JavaResourceContext();
}	
}
